/* 
 * timer.h
 * Functions to init the timers and to add functions to the interrupt handler
 * 2055 Thomas Kulessa <tomk@khm.de>
 */

#ifndef __TIMER__
#define __TIMER__


/* Inits the 8 Bit (counts from 0-255) timer. 
   Sets clock to no 16Mhz/1024, enables the interrupt, resets timer value.
   Is probably to fast.
 */
char timer0_init();

char timer0_add_function(void (*ir)());

/* Inits the 16 Bit (counts from 0-65535) timer. 
   Sets clock to no 16Mhz/256, enables the interrupt, resets timer value.
   Is probably to fast.
 */
char timer1_init();

char timer1_add_function(void (*ir)());

#endif
