/*
 *
 * 2006 Thomas Kulessa <tomk@khm.de>
 *
 */ 
#ifndef F_CPU
#define F_CPU 16000000UL
#endif

#include <avr/delay.h>
#include <avr/io.h>
#include <stdlib.h>
#include <math.h>
#include "actor.h"
#include "serial.h"
#include "global.h"

#define MAX_CNT 50000

int main() 
{
  FILE* out = usart_open();
  unsigned int cnt = 0;

  while ( 1) {
    cnt = 0;
    bit_set(DDRC, DDC5);
    bit_set(PORTC, PB5); 
    _delay_us(15);  
    
    bit_clear(PORTC, PB5); 
    bit_clear(DDRC, DDC5);
    loop_until_bit_is_set(PINC, PINC5);

    while (bit_is_set(PINC, PINC5) && cnt < MAX_CNT) {
      cnt++;
    }
    if (cnt < MAX_CNT) fprintf(out, "cnt=%d\n", cnt);
  }
  _delay_ms(50);
  return 0;

}
