#include "global.h"

typedef struct
{
  unsigned char pin;
  port_t* port;
  unsigned int min, max;
} sonic_t;


/* Initialises a sonic sensor of type SRF05 (1-pin mode).
   First parameter is pointer to a port struct, second number of the pin,
   third the data structure which is returned. Returns 0, if an error occured.
 */
char sonic_init(port_t*, unsigned char pin, sonic_t*);  


/* Sets min, max values for the sensor. Only nescessary to work with normalized 
   values.
 */
void sonic_set_range(sonic_t*, unsigned int, unsigned int);


/* Probes the specified sonic sensor. Implementation is not optimal. Call will 
   take a few us. If the function times out, -1 is returned.
 */
long sonic_get(sonic_t*);


/* Probes the specified sonic sensor. Implementation is not optimal. Call will 
   take a few ms. Return value is in interval [0,1] based on min, max values. 
   If sonic_set_range was not called before -1 is returned;
 */
float sonic_get_norm(sonic_t*);
