#include "sonic.h"
#define F_CPU 16000000UL 
#include <avr/delay.h>


#define MAX_CNT 30000

char sonic_init(port_t* p, unsigned char pin, sonic_t* s)
{
  if (p == 0 || s == 0) return 0;

  s->port = p;
  s->pin  = pin;
  s->min = 0; s->max = 0;

  return 1;
}

void sonic_set_range(sonic_t* s, unsigned int min, unsigned int max) 
{
  if (min<=max) {
    s->min = min;
    s->max = max;
  }
}


long sonic_get(sonic_t* s)
{
  long cnt = 0;

  port_set_direction(s->port, s->pin, 1);
  bit_set(*(s->port->port), s->pin);
  _delay_us(15);

  bit_clear(*(s->port->port), s->pin);
  port_set_direction(s->port, s->pin, 0);
/*   loop_until_bit_is_set(*(s->port->pin), s->pin); */

  while (!bit_is_set(*(s->port->pin), s->pin) && cnt < MAX_CNT)
    cnt++;
  if (cnt>=MAX_CNT)
    return -1;

  cnt = 0;
  while (bit_is_set(*(s->port->pin), s->pin) && cnt < MAX_CNT) 
       cnt++; 
  
  if (cnt >= MAX_CNT) cnt = -1;

  _delay_ms(20);
  return cnt;
} 


/* Probes the specified sonic sensor. Implementation is not optimal. Call will 
   take a few ms. Return value is in interval [0,1] based on min, max values. 
   If sonic_set_range was not called before -1 is returned;
 */
float sonic_get_norm(sonic_t* s)
{
  long val = sonic_get(s);

  if (val == -1 || s->max - s->min == 0) return -1;

  if (val < s->min) val = s->min;
  if (val > s->max) val = s->max;
 
  return (val - s->min) / (double)(s->max - s->min);
}
