/*
 * - print routines for writing to serial port (UART).  
 *
 * 2005 Thomas Kulessa <tomk@khm.de>
 *
 */
#ifndef __SERIAL__
#define __SERIAL__

#include <stdio.h>

#define BAUD  9600
#define CLOCK  16000000

/* Initializes the serial port for input/output 
   see page 135 of Atmel ATmega8 guide.
   Use the following simple print... functions for output.
*/
void usart_init();


/* When using this function for open the serial port for writing
   the standard libc printf functions can be used for output.
   The disadvantage is that they need much more memory than the following
   print functions.
 */
FILE* usart_open();


/* Sends a single character to serial port */
void printchar(char);

/* Sends a string to serial port */
void print(const char*);

/* Sends an integer to serial port */
void printint(unsigned int);

#endif
