#include <avr/io.h>
#include <stdlib.h>

#include "serial.h"

int uart_putchar(char c)
{
  loop_until_bit_is_set(UCSRA, UDRE);
  UDR = c;
  return 0;
}


void usart_init()
{
  /* From offical Atmel MEGA8 docu page 135*/  

  /* Set baud rate */
  const unsigned int baud = 103; /* = 9600 Baud = 16000000/(9600*16)-1 */
  UBRRH = (unsigned char) (baud >> 8);
  UBRRL = (unsigned char) baud;

  /* Enable Receiver and transmitter */
  UCSRB = (1<<RXEN)|(1<<TXEN);

  /* Set frame format: 8data, 2stop bit */
  UCSRC = (1<<URSEL)|(1<<USBS)|(3<<UCSZ0);
}

FILE* usart_open()
{
  usart_init();
  return fdevopen(&uart_putchar, 0, 0);
}

void printint(unsigned int i)
{
  char value[10] = "";
  print(itoa(i, value, 10));
}

void printchar(char c)
{
  /* page 137 */
  while (!(UCSRA & (1<<UDRE)));
  UDR = c;
}

void print(const char* text)
{
  while (*text != 0) 
    printchar(*text++);
}
