/*
 *
 * 2006 Thomas Kulessa <tomk@khm.de>
 *
 */

#include <avr/io.h>
#include <stdlib.h>
#include <math.h>
#include "actor.h"
#include "serial.h"
#include "global.h"


int main() 
{
  port_t led_port;
  led_t led;
  FILE* out = usart_open();
  unsigned int min0=1024, min1=1024, max0=0, max1=0; 

  port_init(&PORTB, &led_port);

  led_init(&led_port, PORTB0, &led);

  adc_init();
/*   adc_set_range(0, 0, 608); */
/*   adc_set_range(1, 0, 643); */


  while( 1 ) {
      const unsigned int val0 = adc_get(0);
      const unsigned int val1 = adc_get(1);
      if (val0<min0) min0=val0;
      if (val1<min1) min1=val1;
      if (val0>max0) max0=val0;
      if (val1>max1) max1=val1;
      adc_set_range(0, min0, max0);
      adc_set_range(1, min1, max1);

      fprintf(out, "ADC0 = %0.2f, %4d, %4d\tADC1 = %0.2f, %4d, %4d\n", 
	      adc_get_norm(0), min0, max0, adc_get_norm(1), min1, max1);
      led_blink(&led, 1);
  }
}
