/*
 *
 * LDR0 IR0 SONIC0 SONIC1 IR1 LDR1
 *                ^ 
 *        MOTOR1  |  MOTOR0
 *                v
 * LDR32 IR2 SONIC2 SONIC3 IR3 LDR3
 *
 * 2006 Thomas Kulessa <tomk@khm.de>
 *
 */

#include <avr/io.h>
#include <stdlib.h>
#include "actor.h"
#include "serial.h"
#include "global.h"
#include "timer.h"


motor_t motor[2];

void motor_func(motor_t *motor)
{
  if (!motor->speed == 0) {
    motor->cnt++;
    if (motor->is_on) {
      motor->max = motor->speed;
      if (motor->cnt>motor->max) {
	bit_clear(*motor->port->port, motor->pin_enable);
	motor->is_on=0;
	motor->cnt=0;
      }
    } else {
      motor->max = MAX_SPEED-motor->speed;
      if (motor->cnt>motor->max) {
	bit_set(*motor->port->port, motor->pin_enable);
	motor->is_on=1;
	motor->cnt=0;
      }
    }
  }
}

void motor_func0()
{
  motor_func(&(motor[0]));
}

void motor_func1()
{
  motor_func(&(motor[1]));
}




int main() 
{
  const float max_speed = 210;
  float myspeed;
  float speed, offset;
  port_t motor_port, led_port;
  led_t led;
  unsigned char c;
  usart_open();

  port_init(&PORTD, &motor_port);
  port_init(&PORTB, &led_port);

  motor_init(&motor_port, PORTD2, PORTD3, PORTD7, &(motor[0])); 
  motor_init(&motor_port, PORTD5, PORTD6, PORTD4, &(motor[1])); 



  led_init(&led_port, PORTB0, &led);

  timer0_init();
  if (!timer0_add_function(&motor_func1)) {
    fprintf(stderr, "Failed to add motor 1 function.\n");
    exit(1);
  }

  if (!timer0_add_function(&motor_func0)) {
     fprintf(stderr, "Failed to add motor 0 function.\n");
     exit(1);
  }

  speed = 0;
  offset = -15;
  myspeed = max_speed;
  while( 1 ) {
      motor_set_speed(&motor[0], myspeed);
      motor_set_speed(&motor[1], myspeed);
      if (speed>max_speed || speed<-max_speed) {
	offset = -offset;
	myspeed = -myspeed;
      }
      speed += offset;
      led_blink(&led, 1);
      delay_s(1);
  }
}
