/* actor.h
 * Functions which implement actors like LEDs, motors etc.
 *
 * 2005 Thomas Kulessa <tomk@khm.de>
 *
 */
#ifndef __ACTOR__
#define __ACTOR__



#include "global.h"

#define MAX_SPEED 255
#define MAX_MOTORS 5;
typedef struct
{
  unsigned char pin_1, pin_2, pin_enable;
  port_t *port;
  int speed, cnt, max;
  char is_on;
} motor_t;


typedef struct
{
  unsigned char state, pin;
  unsigned int intensity, cnt;
  port_t *port;
} led_t;

/* Inits a motor structure.
   First parameter is a pointer to a processor port structure. The next three
   parameters specify the pins to control the motor. The last parameter is a
   pointer to the motor  struct which should get initialised.
*/
char motor_init(port_t*, 
		unsigned char l, 
		unsigned char r, 
		unsigned char enable,
		motor_t*);


/* Sets the speed of a motor. The speed range is from -127 (full speed backwards) 
   to 127 (full speed forward).
 */
void motor_set_speed(motor_t*, int);


/* Returns the current speed of the motor. 
 */
char motor_get_speed(motor_t*);

char led_init(port_t*, unsigned char, led_t*);

void led_set_intensity(led_t*, unsigned int intensity);

void led_on(led_t*);


void led_off(led_t*);

/* A LED blinks for a specified number of times, with a pause of
   approx. one second betwen each blink.
 */
void led_blink(led_t* led, unsigned char);

#endif
