/* actor.c
 * 2005 Thomas Kulessa <tomk@khm.de>
 */

#include <avr/io.h>
#include <math.h>

#include "actor.h"

char motor_init(port_t *p, 
		unsigned char l, 
		unsigned char r, 
		unsigned char enable,
		motor_t *motor)
{
  if (p == 0 || motor == 0)
    return 0;

  motor->port = p;
  motor->pin_1=l; motor->pin_2=r; motor->pin_enable=enable;
/*   port_set_directions(p, _BV(l)|_BV(r)|_BV(enable)); */
  port_set_direction(p, l, 1);
  port_set_direction(p, r, 1);
  port_set_direction(p, enable, 1);
  motor->cnt = 0;
  motor_set_speed(motor, 0); 

  return 1;
}

void motor_set_speed(motor_t* motor, int s)
{
  if (s == 0) {
    bit_set(*motor->port->port, motor->pin_enable);
    bit_clear(*motor->port->port, motor->pin_1);
    bit_clear(*motor->port->port, motor->pin_2);
    motor->is_on=0;
    motor->speed = motor->max = 0;
  } else if (s>0) {
    bit_clear(*motor->port->port, motor->pin_enable);
    bit_set(*motor->port->port, motor->pin_1);
    bit_clear(*motor->port->port, motor->pin_2);
    
    motor->is_on = 1;
    motor->speed = motor->max = s;
  } else {
    bit_clear(*motor->port->port, motor->pin_enable);
    bit_clear(*motor->port->port, motor->pin_1);
    bit_set(*motor->port->port, motor->pin_2);
    
    motor->is_on = 1;
    motor->speed = motor->max = (int)fabs(s);
  }

  if (motor->speed>MAX_SPEED) {
    motor->speed = motor->max = MAX_SPEED;
  }
  
  if (motor->cnt > motor->max)
    motor->cnt = 0;
}


char led_init(port_t* p, unsigned char pin, led_t* l)
{
  if (p == 0 || l == 0) {
    return 0;
  }

  /* Initially off (=0) */
  l->state = 0;
  bit_clear(*p, pin);
  
  /* Set pin */
  l->pin = pin;

  /* intensity = 0 means maximum intensity. LED is state never toggled. */
  l->intensity = 0; l->cnt = 0;

  l->port = p;

  /* Port set to output */
/*   port_set_directions(p, 1<<pin); */
  port_set_direction(p, pin, 1);
  return 1;
}


void led_set_intensity(led_t* t, unsigned int intensity)
{
/*   bit_clear(TIMSK, TOIE1); */
/*   bit_clear(TIMSK, TOIE0); */
  t->intensity = intensity;
  if (t->cnt > intensity)
    t->cnt = 0;
/*   bit_set(TIMSK, TOIE1); */
/*   bit_clear(TIMSK, TOIE0); */
}

void led_on(led_t* led)
{
  bit_set(*led->port->port, led->pin);
  led->state = 1; 
}

void led_off(led_t* led)
{
  bit_clear(*led->port->port, led->pin);
  led->state = 0; 
}

void led_blink(led_t* led, unsigned char times) 
{
  unsigned char c;
  for (c=0;c<times;c++) {
    led_on(led);
    delay_s(1);
    led_off(led);
    delay_s(1);
  }
}
