/*
 *
 * 2006 Thomas Kulessa <tomk@khm.de>
 *
 */

#include <avr/io.h>
#include <stdlib.h>
#include <math.h>
#include "actor.h"
#include "serial.h"
#include "global.h"
#include "timer.h"


motor_t motor[2];

void motor_func(motor_t *motor)
{
  if (!motor->speed == 0) {
    motor->cnt++;
    if (motor->is_on) {
      motor->max = motor->speed;
      if (motor->cnt>motor->max) {
	bit_clear(*motor->port->port, motor->pin_enable);
	motor->is_on=0;
	motor->cnt=0;
      }
    } else {
      motor->max = MAX_SPEED-motor->speed;
      if (motor->cnt>motor->max) {
	bit_set(*motor->port->port, motor->pin_enable);
	motor->is_on=1;
	motor->cnt=0;
      }
    }
  }
}

void motor_func0()
{
  motor_func(&(motor[0]));
}

void motor_func1()
{
  motor_func(&(motor[1]));
}




int main() 
{
  const float max_speed = 210;
  port_t motor_port, led_port;
  led_t led;
  FILE* out = usart_open();

  port_init(&PORTD, &motor_port);
  port_init(&PORTB, &led_port);

  motor_init(&motor_port, PORTD7, PORTD6, PORTD5, &(motor[1]));
  motor_init(&motor_port, PORTD4, PORTD3, PORTD2, &(motor[0]));

  led_init(&led_port, PORTB0, &led);

  timer0_init();
  timer0_add_function(&motor_func0);
  timer0_add_function(&motor_func1);

  adc_init();
  adc_set_range(0, 0, 608);
  adc_set_range(1, 0, 643);


  while( 1 ) {
      const float val0 = adc_get_norm(0);
	  const float val1 = adc_get_norm(1);
/*       fprintf(out, "speed[%d]=%f\n", 0, speed0); */
      motor_set_speed(&motor[0], max_speed*(1-val1));
      motor_set_speed(&motor[1], max_speed*(1-val0));
      led_blink(&led, 3);
  }
}
